// import React from "react";
// import { useState } from "react";
// import LoginPage from "./pages/LoginPage";
// import OTPPage from "./pages/OTPPage";
// import Dashboard from "./pages/Dashboard";

// export default function App() {
//   const [step, setStep] = useState("login");
//   const [nationalId, setNationalId] = useState("");

//   if (step === "login") {
//     return <LoginPage onOTPSent={(id) => { setNationalId(id); setStep("otp"); }} />;
//   }
//   if (step === "otp") {
//     return <OTPPage nationalId={nationalId} onLoginSuccess={() => setStep("dashboard")} />;
//   }
//   return <Dashboard />;
// }


// import React, { useState } from "react";
// import { BrowserRouter as Router, Routes, Route, useNavigate } from "react-router-dom";
// import LoginPage from "./pages/LoginPage";
// import OTPPage from "./pages/OTPPage";
// import Dashboard from "./pages/Dashboard";

// function AppRoutes() {
//   const [nationalId, setNationalId] = useState("");
//   const navigate = useNavigate();

//   return (
//     <Routes>
//       <Route
//         path="/"
//         element={
//           <LoginPage
//             onOTPSent={(id) => {
//               setNationalId(id);
//               navigate("/otp");
//             }}
//           />
//         }
//       />
//       <Route
//         path="/otp"
//         element={
//           <OTPPage
//             nationalId={nationalId}
//             onLoginSuccess={() => navigate("/dashboard")}
//           />
//         }
//       />
//       <Route path="/dashboard" element={<Dashboard />} />
//     </Routes>
//   );
// }

// export default function App() {
//   return (
//     <Router>
//       <AppRoutes />
//     </Router>
//   );
// }


import React, { useState, useEffect } from "react";
import {
  BrowserRouter as Router,
  Routes,
  Route,
  Navigate,
  useNavigate,
} from "react-router-dom";
import LoginPage from "./pages/LoginPage";
import OTPPage from "./pages/OTPPage";
import Dashboard from "./pages/Dashboard";

function AppRoutes() {
  const [nationalId, setNationalId] = useState("");
  const [isAuthenticated, setIsAuthenticated] = useState(
    localStorage.getItem("isAuthenticated") === "true"
  );
  const navigate = useNavigate();

  useEffect(() => {
    if (isAuthenticated) {
      navigate("/dashboard");
    }
  }, [isAuthenticated, navigate]);

  return (
    <Routes>
      <Route
        path="/"
        element={
          <LoginPage
            onOTPSent={(id) => {
              setNationalId(id);
              navigate("/otp");
            }}
          />
        }
      />

      <Route
        path="/otp"
        element={
          <OTPPage
            nationalId={nationalId}
            onLoginSuccess={() => {
              localStorage.setItem("isAuthenticated", "true");
              setIsAuthenticated(true);
            }}
          />
        }
      />

      <Route
        path="/dashboard"
        element={
          isAuthenticated ? (
            <Dashboard
              onLogout={() => {
                localStorage.removeItem("isAuthenticated");
                setIsAuthenticated(false);
                navigate("/");
              }}
            />
          ) : (
            <Navigate to="/" replace />
          )
        }
      />

      {/* Fallback for any unknown route */}
      <Route path="*" element={<Navigate to="/" replace />} />
    </Routes>
  );
}

export default function App() {
  return (
    <Router>
      <AppRoutes />
    </Router>
  );
}
